
#ifdef MACVERSION 
#include <standard.h>
#endif

#ifdef WIN95VERSION 
#include "standard.h"
#endif

#include "shell.h"
#include "shellprivate.h"




#define ctblocks 5 /*we can remember blocked events up to 5 levels deep*/

static short topblocks = 0;

static short blockstack [ctblocks];

static short blockedevents = 0;



short shellblockedevents (void) {
	
	return (blockedevents);
	} /*shellblockedevents*/


boolean shellblocked (short mask) {
	
	return ((blockedevents & mask) != 0);
	} /*shellblocked*/


boolean shellpushblock (short mask, boolean flblock) {
	
	if (topblocks >= ctblocks)
		return (false);
	
	blockstack [topblocks++] = blockedevents;
	
	if (flblock)
		blockedevents |= mask;
	else
		blockedevents &= ~mask;
	
	return (true);
	} /*shellpushblock*/


boolean shellpopblock (void) {
	
	if (topblocks <= 0)
		return (false);
	
	blockedevents = blockstack [--topblocks];
	
	return (true);
	} /*shellpopblock*/
	


static short shelleventsdisable = 0;


boolean shelleventsblocked (void) {
	
	return (shelleventsdisable > 0);
	} /*shelleventsblocked*/
	
	
boolean shellblockevents (void) {
	
	++shelleventsdisable;
	
	return (true);
	} /*shellblockevents*/
	

boolean shellpopevents (void) {
	
	if (shelleventsdisable <= 0)
		return (false);
	
	--shelleventsdisable;
	
	return (true);
	} /*shellpopevents*/
	
	
